<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */

  /*===================================================
    ShowCustomField()
  ===================================================*/

  function ShowCustomField() {

    // vars global configuration
    global $dbConn, $admin_template_path;

    // vars url & form

    // vars messages

    // vars template
    global $columns, $field, $type, $attribute, $action;

    $query = "show fields from idx_link";
    $result = $dbConn->Execute($query);
    $num_field =  $result->RecordCount() - 1;

    if ($result) {
      $i = 0;
      while($row = $result->FetchRow($result)) {
        // 27 is last field pre-defined offset
        if ($i < 27) {
          $i++;
          continue;
        }

        $field = $row["Field"];
        $type = $row["Type"];

        $row = $dbConn->FetchOne("select * from idx_custom_field where field_name = '$field'");
        $type = $row['field_type'];
        $required = ($row['required']) ? 'REQUIRED' : '';
        $searchable = '';
        if ($row['field_type'] != 'IMAGE' && $row['field_type'] != 'FILE') {
          $searchable = ($row['searchable']) ? 'SEARCHABLE' : '';
        }
        $attribute = trim("$required $searchable");
        if ($row['permission'] == 1) {
          $attribute .= " (registered users only)";
        }
        if ($row['permission'] == 2) {
          $attribute .= " (admin only)";
        }

        $action_up = "<a href='link_custom_field.php?pflag=move&direction=up&id=$field'>[Up]</a>";
        $action_down = "<a href='link_custom_field.php?pflag=move&direction=down&id=$field'>[Down]</a>";

        if ($i == 27) {
          $action_up = "<font color='#666666'><b>[Up]</b></font>";
          if ($num_field == 27) {
            $action_down = "<font color='#666666'><b>[Down]</b></font>";
          }
        }

        if ($i == $num_field) {
          $action_down = "<font color='#666666'><b>[Down]</b></font>";
        }

        $action = "
          <font size=1>
          $action_down
          $action_up
          <a href='link_custom_field_change.php?id=$field'>[Change]</a>
          <a href='link_custom_field.php?pflag=delete&id=$field'>[Drop]</a>
          </font>
        ";

        global $tbl_class;
        if($i%2) $tbl_class = "tbl_light";
        else $tbl_class = "tbl_light2";

        $columns .= EvalTemplate($admin_template_path . "link_custom_field_columns.html",
          "\$field,\$type,\$attribute,\$action,\$tbl_class");

        $i++;
      }
    }

    $db_query = stripslashes($db_query);

    DisplayTemplate($admin_template_path . "link_custom_field.html",
      "\$columns,\$field,\$db_query");
  }


  /*===================================================
    ProcessFormAddField()
  ===================================================*/

  function ProcessFormAddField() {

    // vars global configuration
    global $dbConn, $admin_template_path;

    // vars url & form
    global $field, $text, $type, $option, $required, $searchable, $permission,
             $img_width, $img_height, $file_size, $file_extension;

    // vars messages
    global $msg;

    // vars template
    global $message, $back;

    if(empty($field)) { $error_msg = $msg["20361"]; }
    elseif(empty($type)) { $error_msg = $msg["20362"]; }
    elseif(!IsAlphanumericUnderscore($field)) { $error_msg = $msg["20363"]; }

    if(empty($error_msg)) {
      $field = strtolower($field);

      switch($type) {
        case 'TEXTAREA':
        case 'MULTISELECT':
          $field_type = 'text';
          break;
        case 'DATE':
        case 'DATETIME':
          $field_type = $type;
          break;
        default:
          $field_type = 'varchar(255)';
      }

      $query = "alter table idx_link add `$field` $field_type";
      $result = $dbConn->Execute($query);

      $query = "alter table idx_link_temp add `$field` $field_type";
      $result = $dbConn->Execute($query);

      $option = trim($option);
      $query = "insert into idx_custom_field
                (field_name, field_text, field_type, field_option, field_img_width, field_img_height, field_file_size, field_file_extension, required, searchable, permission) values
                ('$field', '$text', '$type', '$option', '$img_width', '$img_height', '$file_size', '$file_extension', '$required', '$searchable', '$permission')";
      $result = $dbConn->Execute($query);

      $message = $msg["20371"];
      $back = "<a href=link_custom_field.php>Back</a>";
    }
    else
      $message = $error_msg;

    DisplayTemplate($admin_template_path . "message.html", "\$message,\$back");
  }


  /*===================================================
    ProcessFormDeleteField()
  ===================================================*/

  function ProcessFormDeleteField() {

    // vars global configuration
    global $dbConn, $admin_template_path;

    // vars url & form
    global $id;

    // vars messages
    global $msg;

    // vars template
    global $message, $back;

    $field = $id;

    $query = "alter table idx_link drop `$field`";
    $result = $dbConn->Execute($query);

    $query = "alter table idx_link_temp drop `$field`";
    $result = $dbConn->Execute($query);

    $query = "delete from idx_custom_field where name = '$field'";
    $result = $dbConn->Execute($query);

    $message = $msg["20372"];
    $back = "<a href=link_custom_field.php>Back</a>";

    DisplayTemplate($admin_template_path . "message.html", "\$message,\$back");
  }


  /*===================================================
    ProcessFormMoveField()
  ===================================================*/

  function ProcessFormMoveField() {

    // vars global configuration
    global $dbConn, $admin_template_path;

    // vars url & form
    global $id, $direction;

    // vars messages
    global $msg;

    // vars template
    global $message, $back;

    $field = $id;

    $query = "show fields from idx_link";
    $result = $dbConn->Execute($query);
    $i = 0;
    while ($row = $result->FetchRow($result)) {
      $i++;
      $fields[$i] = $row;
      if ($row["Field"] == $field) {
        $current_field = $row;
        $i_current = $i;
      }
    }
    $prev_field = $fields[$i_current - 2];
    $next_field = $fields[$i_current + 1];

    if ($direction == 'up') {
      $query = "alter table idx_link change `$current_field[Field]` `$current_field[Field]` $current_field[Type] after `$prev_field[Field]`";
      $result = $dbConn->Execute($query);
      $query = "alter table idx_link_temp change `$current_field[Field]` `$current_field[Field]` $current_field[Type] after `$prev_field[Field]`";
      $result = $dbConn->Execute($query);
    }

    if ($direction == 'down') {
      $query = "alter table idx_link change `$current_field[Field]` `$current_field[Field]` $current_field[Type] after `$next_field[Field]`";
      $result = $dbConn->Execute($query);
      $query = "alter table idx_link_temp change `$current_field[Field]` `$current_field[Field]` $current_field[Type] after `$next_field[Field]`";
      $result = $dbConn->Execute($query);
    }
    
    Redirect('link_custom_field.php');
  }


  /*===================================================
    main
  ===================================================*/

  include "../application.php";
  
  RunPreFilter(__FILE__);

  if ($pflag != 'move') {
    DisplayTemplate($admin_template_path . "header.html");
  }
  if(empty($pflag)) {
    ShowCustomField();
  }
  elseif ($pflag == 'add') {
    ProcessFormAddField();
  }
  elseif ($pflag == 'delete') {
    ProcessFormDeleteField();
  }
  elseif ($pflag == 'move') {
    ProcessFormMoveField();
  }
  DisplayTemplate($admin_template_path . "footer.html");

  RunPostFilter(__FILE__);

?>